/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.item;

import java.util.List;
import net.creeperhost.chickens.entity.EntityColoredEgg;
import net.creeperhost.chickens.handler.IColorSource;
import net.creeperhost.chickens.init.ModChickens;
import net.creeperhost.chickens.init.ModEntities;
import net.creeperhost.chickens.registry.ChickensRegistry;
import net.creeperhost.chickens.registry.ChickensRegistryItem;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemColoredEgg
extends Item
implements IColorSource {
    public ItemColoredEgg(Item.Properties properties) {
        super(properties);
    }

    @Override
    public int getColorFromItemStack(ItemStack stack, int renderPass) {
        try {
            int colourid = stack.m_41783_().m_128451_("colourid");
            DyeColor dyeColor = DyeColor.m_41053_((int)colourid);
            if (dyeColor != null) {
                return ModChickens.getRGB(dyeColor);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
        return 0;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level p_41422_, List<Component> tooltip, TooltipFlag p_41424_) {
        super.m_7373_(itemStack, p_41422_, tooltip, p_41424_);
        tooltip.add((Component)new TranslatableComponent("item.colored_egg.tooltip"));
    }

    public Component m_7626_(ItemStack stack) {
        if (!stack.m_41782_()) {
            return new TextComponent("null");
        }
        String name = stack.m_41783_().m_128461_("id");
        String[] split = name.split(":");
        String s = split[1].replace("_chicken", "");
        return new TranslatableComponent("item.colored_egg." + s + ".name");
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> subItems) {
        if (this.m_41389_(tab)) {
            try {
                if (ChickensRegistry.getItems() != null) {
                    for (ChickensRegistryItem chicken : ChickensRegistry.getItems()) {
                        if (!chicken.isDye()) continue;
                        ItemStack stack = new ItemStack((ItemLike)this, 1);
                        CompoundTag compoundTag = new CompoundTag();
                        compoundTag.m_128359_("id", chicken.getRegistryName().toString());
                        Item item = chicken.getLayItemHolder().getItem();
                        if (item instanceof DyeItem) {
                            DyeItem dyeItem = (DyeItem)item;
                            DyeColor dyeColor = dyeItem.m_41089_();
                            int id = dyeColor.m_41060_();
                            compoundTag.m_128405_("colourid", id);
                        }
                        stack.m_41751_(compoundTag);
                        subItems.add((Object)stack);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        String chickenType;
        ItemStack itemStackIn = player.m_21120_(interactionHand);
        if (!player.m_7500_()) {
            itemStackIn.m_41774_(1);
        }
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11877_, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.f_46441_.nextFloat() * 0.4f + 0.8f));
        if (!level.f_46443_ && (chickenType = itemStackIn.m_41783_().m_128461_("id")) != null) {
            EntityColoredEgg entityIn = (EntityColoredEgg)((EntityType)ModEntities.EGG.get()).m_20615_(level);
            entityIn.m_37446_(itemStackIn);
            entityIn.setChickenType(chickenType);
            entityIn.m_6034_(player.m_20185_(), player.m_20188_() - 0.1, player.m_20189_());
            entityIn.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
            entityIn.m_5602_((Entity)player);
            level.m_7967_((Entity)entityIn);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStackIn);
    }
}

